﻿using ProChain.Api.Base;

namespace ProChain.Fusion.Sdk.Examples
{
    public class InMemoryStorage : ILocalStorage
    {
        private readonly Dictionary<string, string> _storage = new Dictionary<string, string>();

        public Task<string?> Get(string key)
        {
            return Task.FromResult(_storage.GetValueOrDefault(key));
        }

        public Task Set(string key, string value)
        {
            _storage[key] = value;

            return Task.CompletedTask;
        }
    }
}